/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.io.ByteToCharCp1250;
import sun.io.CharToByteCp1250;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.SingleByteDecoder;
import sun.nio.cs.SingleByteEncoder;
import sun.nio.cs.StandardCharsets;

public class MS1250
extends Charset
implements HistoricallyNamedCharset {
    public MS1250() {
        super("windows-1250", StandardCharsets.aliasesFor("windows-1250"));
    }

    public String historicalName() {
        return "Cp1250";
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS1250;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends SingleByteDecoder {
        private static ByteToCharCp1250 b2c = new ByteToCharCp1250();

        public Decoder(Charset charset) {
            super(charset, b2c.getByteToCharTable());
        }
    }

    private static class Encoder
    extends SingleByteEncoder {
        private static CharToByteCp1250 c2b = new CharToByteCp1250();

        public Encoder(Charset charset) {
            super(charset, c2b.getIndex1(), c2b.getIndex2(), 65280, 255, 8);
        }
    }
}

